% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_rows.R
\name{separate_rows}
\alias{separate_rows}
\title{Separate a collapsed column into multiple rows}
\usage{
separate_rows(.df, ..., sep = "[^[:alnum:].]+", convert = FALSE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to separate across multiple rows. \code{tidyselect} compatible}

\item{sep}{Separator delimiting collapsed values}

\item{convert}{If TRUE, runs \code{type.convert()} on the resulting column.
Useful if the resulting column should be type integer/double.}
}
\description{
If a column contains observations with multiple delimited values, separate them each into their own row.
}
\examples{
df <- data.table(
  x = 1:3,
  y = c("a", "d,e,f", "g,h"),
  z = c("1", "2,3,4", "5,6")
)

separate_rows(df, y, z)

separate_rows(df, y, z, convert = TRUE)
}
