% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_split.R
\name{group_split.}
\alias{group_split.}
\title{Split data frame by groups}
\usage{
group_split.(.df, ..., .keep = TRUE)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Columns to group and split by. \code{tidyselect} compatible.}

\item{.keep}{Should the grouping columns be kept}
}
\description{
Split data frame by groups. Returns a list.
}
\examples{
test_df <- tidytable(
  a = 1:5,
  b = 1:5,
  c = c("a","a","a","b","b"),
  d = c("a","a","a","b","b"))

test_df \%>\%
  group_split.(c, d)

test_df \%>\%
  group_split.(c, d, .keep = FALSE)
}
