% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_across.R
\name{mutate_across.}
\alias{mutate_across.}
\alias{dt_mutate_across}
\title{Mutate multiple columns simultaneously}
\usage{
mutate_across.(.df, .cols = everything(), .fns, ..., by = NULL)

dt_mutate_across(.df, .cols = everything(), .fns, ..., by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{.cols}{vector \code{c()} of unquoted column names
\code{tidyselect} compatible.}

\item{.fns}{Functions to pass. Can pass a list of functions.}

\item{...}{Other arguments for the passed function}

\item{by}{Columns to group by}
}
\description{
Mutate multiple columns simultaneously.
}
\examples{
test_df <- data.table(
  x = c(1,1,1),
  y = c(2,2,2),
  z = c("a", "a", "b"))

test_df \%>\%
  mutate_across.(where(is.numeric), as.character)

test_df \%>\%
  mutate_across.(c(x, y), ~ .x * 2)

test_df \%>\%
  mutate_across.(everything(), as.character)

test_df \%>\%
  mutate_across.(c(x, y), list(new = ~ .x * 2,
                               another = ~ .x + 7))
}
