% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize.}
\alias{summarize.}
\alias{summarise.}
\alias{dt_summarise}
\alias{dt_summarize}
\title{Aggregate data using summary statistics}
\usage{
summarize.(.data, ..., by = NULL)

summarise.(.data, ..., by = NULL)

dt_summarise(.data, ..., by = NULL)

dt_summarize(.data, ..., by = NULL)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Aggregations to perform}

\item{by}{Columns to group by.
\itemize{
\item A single column can be passed with \code{by = d}.
\item Multiple columns can be passed with \code{by = c(c, d)} or \code{by = list(c, d)}
\item Enhanced selection can be used:
\itemize{
\item Single predicate: \code{by = is.character}
\item Multiple predicates: \code{by = c(is.character, is.factor)}
\item A combination of predicates and column names: \code{by = c(is.character, b)}
}
}}
}
\description{
Aggregate data using summary statistics such as mean or median. Can be calculated by group.
}
\examples{
example_dt <- data.table::data.table(
  a = c(1,2,3),
  b = c(4,5,6),
  c = c("a","a","b"),
  d = c("a","a","b"))

example_dt \%>\%
  summarize.(avg_a = mean(a),
             max_b = max(b),
             by = c)

example_dt \%>\%
  summarize.(avg_a = mean(a),
               by = c(c, d))
}
