% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{dt_left_join}
\alias{dt_left_join}
\alias{dt_inner_join}
\alias{dt_right_join}
\alias{dt_full_join}
\alias{dt_anti_join}
\title{Join two data.tables together}
\usage{
dt_left_join(x, y, by = NULL)

dt_inner_join(x, y, by = NULL)

dt_right_join(x, y, by = NULL)

dt_full_join(x, y, by = NULL, suffix = c(".x", ".y"))

dt_anti_join(x, y, by = NULL)
}
\arguments{
\item{x}{A data.frame or data.table}

\item{y}{A data.frame or data.table}

\item{by}{A character vector of variables to join by. If NULL, the default, the join will do a natural join, using all variables with common names across the two tables.}

\item{suffix}{Append created for duplicated column names when using `dt_full_join()`}
}
\value{
A data.table
}
\description{
Join two data.tables together
}
\examples{
df1 <- data.table::data.table(x = c("a","a","a","b","b"), y = 1:5)
df2 <- data.table::data.table(x = c("a","b"), z = 1:2)

df1 \%>\% dt_left_join(df2)
df1 \%>\% dt_inner_join(df2)
df1 \%>\% dt_right_join(df2)
df1 \%>\% dt_full_join(df2)
df1 \%>\% dt_anti_join(df2)
}
