% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_variants.R
\name{dt_mutate_if}
\alias{dt_mutate_if}
\alias{dt_mutate_at}
\alias{dt_mutate_across}
\alias{dt_mutate_all}
\title{Mutate}
\usage{
dt_mutate_if(.data, .predicate, .funs, ...)

dt_mutate_at(.data, .vars, .funs, ...)

dt_mutate_across(.data, .cols, .funs, ...)

dt_mutate_all(.data, .funs, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{.predicate}{predicate for \code{dt_mutate_if()} to use}

\item{.funs}{Functions to pass. Can pass a list of functions.}

\item{...}{Other arguments for the passed function}

\item{.vars}{vector \code{c()} of bare column names for \code{dt_mutate_at()} to use}

\item{.cols}{vector \code{c()} of bare column names for \code{dt_mutate_across()} to use}
}
\value{
A data.table
}
\description{
Edit existing columns. Supports enhanced selection.

There are two variants:
\itemize{
\item \code{dt_mutate_all()}
\item \code{dt_mutate_across()}: Replaces both \code{mutate_if()} & \code{mutate_at()}
}
}
\examples{
library(data.table)

example_dt <- data.table::data.table(
  x = c(1,1,1),
  y = c(2,2,2),
  z = c("a", "a", "b"))

example_dt \%>\%
  as_dt() \%>\%
  dt_mutate_across(is.numeric, as.character)

example_dt \%>\%
  as_dt() \%>\%
  dt_mutate_across(c(x, y), ~ .x * 2)

example_dt \%>\%
  as_dt() \%>\%
  dt_mutate_across(c(x, y), list(new = ~ .x * 2))
}
