% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest.}
\alias{unnest.}
\title{Unnest list-columns}
\usage{
unnest.(
  .df,
  ...,
  keep_empty = FALSE,
  .drop = TRUE,
  names_sep = NULL,
  names_repair = "unique"
)
}
\arguments{
\item{.df}{A data.table}

\item{...}{Columns to unnest If empty, unnests all list columns. \code{tidyselect} compatible.}

\item{keep_empty}{Return \code{NA} for any \code{NULL} elements of the list column}

\item{.drop}{Should list columns that were not unnested be dropped}

\item{names_sep}{If NULL, the default, the inner column names will become the new outer column names.

If a string, the name of the outer column will be appended to the beginning of the inner column names,
with \code{names_sep} used as a separator.}

\item{names_repair}{Treatment of duplicate names. See \code{?vctrs::vec_as_names} for options/details.}
}
\description{
Unnest list-columns.
}
\examples{
df1 <- tidytable(x = 1:3, y = 1:3)
df2 <- tidytable(x = 1:2, y = 1:2)
nested_df <-
  data.table(
    a = c("a", "b"),
    frame_list = list(df1, df2),
    vec_list = list(4:6, 7:8)
  )

nested_df \%>\%
  unnest(frame_list)

nested_df \%>\%
  unnest(frame_list, names_sep = "_")

nested_df \%>\%
  unnest(frame_list, vec_list)
}
\keyword{internal}
