% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-print.R
\name{sqprint}
\alias{sqprint}
\alias{sq-print}
\title{Print sq object}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{max_sequences}{[\code{integer(1)}]\cr
How many sequences should be printed.}

\item{use_color}{[\code{logical(1)}]\cr
Should sequences be colored?}

\item{letters_sep}{[\code{character(1)}]\cr
How the letters should be separated.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
An object that was passed as the first argument to the function.
It is returned invisibly (equivalent of \code{invisible(x)})
}
\description{
Prints input \code{\link[=sq-class]{sq}} object in a
human-friendly form.
}
\details{
\code{print} method is often called implicitly by calling variable name.
Only explicit calling of this method allows its parameters to be changed.

Printed information consists of three parts:
\itemize{
\item First line is always a header that contains info about the type of
 sequences contained.
\item The next part is the content. Each sequence has its own line, but not
 all sequences are printed. The number of printed sequences is limited by
 parameter \code{max_sequences}, defaulting to 10. These sequences are
 printed with:
 \itemize{
 \item left-aligned index of sequence in square brackets (e.g. \code{[3]}),
 \item left-aligned sequence data (more about it in paragraph below),
 \item right-aligned sequence length in angle brackets (e.g. \code{<27>}).
 }
\item Finally, if number of sequences is greater than \code{max_sequences},
 then a footer is displayed with how many sequences are there and how many
 were printed.
}

Each sequence data is printed as letters. If sequence is too long to fit in
one line, then only a subsequence is displayed - a subsequence that begins
from the first letter. Sequence printing is controlled by \code{letters_sep}
and \code{NA_letter} parameters. The first one specifies a string that should
be inserted between any two letters. By default it's empty when all letters
are one character in length; and a space otherwise. \code{NA_letter} dictates
how \code{NA} values are displayed, by default it's an exclamation mark
("\code{!}").

Most consoles support color printing, but when any of these do not, then the
user might use \code{use_color} parameter set to \code{FALSE} - or better
yet, change related option value, where said option is called
\code{"tidysq_print_use_color"}.
}
\examples{
# Creating objects to work on:
sq_ami <- sq(c("MIAANYTWIL","TIAALGNIIYRAIE", "NYERTGHLI", "MAYXXXIALN"),
             alphabet = "ami_ext")
sq_dna <- sq(c("ATGCAGGA", "GACCGNBAACGAN", "TGACGAGCTTA"),
             alphabet = "dna_bsc")
sq_unt <- sq(c("ATGCAGGA?", "TGACGAGCTTA", "", "TIAALGNIIYRAIE"))

# Printing without explicit function calling with default parameters:
sq_ami
sq_dna
sq_unt

# Printing with explicit function calling and specific parameters:
print(sq_ami)
print(sq_dna, max_sequences = 1, use_color = FALSE)
print(sq_unt, letters_sep = ":")

}
\seealso{
Functions that display sequence info:
\code{\link{get_tidysq_options}()}
}
\concept{display_functions}
