% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{arrange}
\alias{arrange}
\alias{arrange.default}
\alias{bind_rows}
\alias{bind_cols}
\title{drplyr-methods}
\usage{
arrange(.data, ..., .by_group = FALSE)

\method{arrange}{default}(.data, ..., .by_group = FALSE)

bind_rows(..., .id = NULL, add.cell.ids = NULL)

bind_cols(..., .id = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{<[`tidy-eval`][dplyr_tidy_eval]> Variables, or functions or
variables. Use [desc()] to sort a variable in descending order.}

\item{.by_group}{If `TRUE`, will sort first by grouping variable. Applies to
grouped data frames only.}

\item{.id}{Data frame identifier.

  When `.id` is supplied, a new column of identifiers is
  created to link each row to its original data frame. The labels
  are taken from the named arguments to `bind_rows()`. When a
  list of data frames is supplied, the labels are taken from the
  names of the list. If no names are found a numeric sequence is
  used instead.}

\item{add.cell.ids}{from Seurat 3.0 A character vector of length(x = c(x, y)). Appends the corresponding values to the start of each objects' cell names.}
}
\value{
A tibble
Arrange rows by column values

An object of the same type as `.data`.

* All rows appear in the output, but (usually) in a different place.
* Columns are not modified.
* Groups are not modified.
* Data frame attributes are preserved.
}
\description{
`arrange()` order the rows of a data frame rows by the values of selected
columns.

Unlike other dplyr verbs, `arrange()` largely ignores grouping; you
need to explicit mention grouping variables (or use  `by_group = TRUE`)
in order to group by them, and functions of variables are evaluated
once per data frame, not once per group.
}
\details{
## Locales
The sort order for character vectors will depend on the collating sequence
of the locale in use: see [locales()].

## Missing values
Unlike base sorting with `sort()`, `NA` are:
* always sorted to the end for local data, even when wrapped with `desc()`.
* treated differently for remote data, depending on the backend.
}
\section{Methods}{

This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
}

\examples{
`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% arrange(nFeature_RNA)
}
\seealso{
Other single table verbs: 
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
