% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-ref-functions.R
\name{excel_ref_functions}
\alias{excel_ref_functions}
\alias{VLOOKUP}
\title{Excel Reference Functions}
\usage{
VLOOKUP(.lookup_values, .data, .lookup_column, .return_column)
}
\arguments{
\item{.lookup_values}{One or more lookup values.}

\item{.data}{A \code{data.frame} or \code{tibble} that contains values to evaluate and return}

\item{.lookup_column}{The column in \code{.data} containing exact matching values of the \code{.lookup_values}}

\item{.return_column}{The column in \code{.data} containing the values to return if a match is found}
}
\value{
Returns a vector the length of the input lookup values
}
\description{
Excel reference functions are used to efficiently lookup values from a data source.
The most popular lookup function is "VLOOKUP", which has been implemented in R.

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names are similar to Excel function names
\item Functionality replicates Excel
}
}
\details{
\strong{\code{\link[=VLOOKUP]{VLOOKUP()}} Details}
\itemize{
\item Performs exact matching only. Fuzzy matching is not implemented.
\item Can only return values from one column only. Use \code{dplyr::left_join()} to perform table joining.
}
}
\examples{
library(tidyquant)
library(tidyverse)

lookup_table <- tibble(
    stock   = c("FB", "AMZN", "NFLX", "GOOG"),
    company = c("Facebook", "Amazon", "Netflix", "Google")
)

# --- Basic Usage ---

VLOOKUP("NFLX",
        .data = lookup_table,
        .lookup_column = stock,
        .return_column = company)

# --- Usage with tidyverse ---

# Add company names to the stock data
FANG \%>\%
    mutate(company = VLOOKUP(symbol, lookup_table, stock, company))

}
