% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel-stat-mutation-functions.R
\name{excel_stat_mutation_functions}
\alias{excel_stat_mutation_functions}
\alias{ABS}
\alias{SQRT}
\alias{LOG}
\alias{EXP}
\alias{RETURN}
\alias{PCT_CHANGE}
\alias{CHANGE}
\alias{LAG}
\alias{LEAD}
\alias{CUMULATIVE_SUM}
\alias{CUMULATIVE_PRODUCT}
\alias{CUMULATIVE_MAX}
\alias{CUMULATIVE_MIN}
\alias{CUMULATIVE_MEAN}
\alias{CUMULATIVE_MEDIAN}
\title{Excel Statistical Mutation Functions}
\usage{
ABS(x)

SQRT(x)

LOG(x)

EXP(x)

RETURN(x, n = 1, fill_na = NA)

PCT_CHANGE(x, n = 1, fill_na = NA)

CHANGE(x, n = 1, fill_na = NA)

LAG(x, n = 1, fill_na = NA)

LEAD(x, n = 1, fill_na = NA)

CUMULATIVE_SUM(x)

CUMULATIVE_PRODUCT(x)

CUMULATIVE_MAX(x)

CUMULATIVE_MIN(x)

CUMULATIVE_MEAN(x)

CUMULATIVE_MEDIAN(x)
}
\arguments{
\item{x}{A vector. Most functions are designed for numeric data.}

\item{n}{Values to offset. Used in functions like \code{\link[=LAG]{LAG()}}, \code{\link[=LEAD]{LEAD()}}, and \code{\link[=PCT_CHANGE]{PCT_CHANGE()}}}

\item{fill_na}{Fill missing (\code{NA}) values with a different value. Used in offsetting functions.}
}
\value{
\itemize{
\item \strong{Mutation functions} return a mutated / transformed version of the vector
}
}
\description{
15+ common statistical functions familiar to users of Excel (e.g. \code{\link[=ABS]{ABS()}}, \code{\link[=SQRT]{SQRT()}})
that \strong{modify / transform} a series of values
(i.e. a vector of the same length of the input is returned).

These functions are designed to help users coming from an \strong{Excel background}.
Most functions replicate the behavior of Excel:
\itemize{
\item Names in most cases match Excel function names
\item Functionality replicates Excel
\item By default, missing values are ignored (same as in Excel)
}
}
\section{Useful functions}{


\strong{Mutation Functions} - Transforms a vector
\itemize{
\item Transformation: \code{\link[=ABS]{ABS()}}, \code{\link[=SQRT]{SQRT()}}, \code{\link[=LOG]{LOG()}}, \code{\link[=EXP]{EXP()}}
\item Lags & Change (Offsetting Functions): \code{\link[=CHANGE]{CHANGE()}}, \code{\link[=PCT_CHANGE]{PCT_CHANGE()}}, \code{\link[=LAG]{LAG()}}, \code{\link[=LEAD]{LEAD()}}
\item Cumulative Totals: \code{\link[=CUMULATIVE_SUM]{CUMULATIVE_SUM()}}, \code{\link[=CUMULATIVE_PRODUCT]{CUMULATIVE_PRODUCT()}}
}
}

\examples{
# Libraries
library(tidyquant)
library(timetk)
library(tidyverse)
library(forcats)

# --- Basic Usage ----

CUMULATIVE_SUM(1:10)

PCT_CHANGE(c(21, 24, 22, 25), fill_na = 0)

# --- Usage with tidyverse ---

# Go from daily to monthly periodicity,
# then calculate returns and growth of $1 USD
FANG \%>\%
    mutate(symbol = as_factor(symbol)) \%>\%
    group_by(symbol) \%>\%

    # Summarization - Collapse from daily to FIRST value by month
    summarise_by_time(
        .date_var  = date,
        .by        = "month",
        adjusted   = FIRST(adjusted)
    ) \%>\%

    # Mutation - Calculate monthly returns and cumulative growth of $1 USD
    group_by(symbol) \%>\%
    mutate(
        returns = PCT_CHANGE(adjusted, fill_na = 0),
        growth  = CUMULATIVE_SUM(returns) + 1
    )

}
