% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{generate_case_when_trees}
\alias{generate_case_when_trees}
\title{Generate trees}
\usage{
generate_case_when_trees(parsedmodel, default = TRUE)
}
\description{
Each tree is generated as a flat tree with each node being a seperate part of
the case when.
This means that the following tree:
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{        +-----+
   +----|x > 0|----+
   |    +-----+    |
   v               v
}\if{html}{\out{</div>}}

+------+        +--------+
+--|y < 20|--+  +--|z <= 10 |--+
|  +------+  |  |  +--------+  |
v            v  v              v
a            b  c              d

will be turned into the following \code{case_when()} statement.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{case_when(
  x >  0 & y <  20 ~ "a",
  x >  0 & y >= 20 ~ "b",
  x <= 0 & z <= 10 ~ "c",
  x <= 0 & z >  10 ~ "d"
)
}\if{html}{\out{</div>}}

instead of a nested \code{case_when()}s` like this

\if{html}{\out{<div class="sourceCode r">}}\preformatted{case_when(
  x >  0 ~ case_when(
             y <  20 ~ "a",
             y >= 10 ~ "b"
           ),
  x <= 0 ~ case_when(
             z <= 10 ~ "c",
             z >  10 ~ "d"
           )
)
}\if{html}{\out{</div>}}

The functions in this file generates these tree.
\code{generate_case_when_tree()} generates a single tree with
\code{generate_case_when_trees()} being a convinience wrapper for multiple trees.

\code{generate_tree_node()} generates the expressions for each a single ndoe in
the tree, where \code{generate_tree_nodes()} is a convinience wrapper for
calculating all notes.
}
\keyword{internal}
