% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_plate.R
\name{check_plate}
\alias{check_plate}
\title{Checks whether the input file can be used to transform to a tidy plate using
the \code{tidy_plate()} function}
\usage{
check_plate(file, well_id = "well", sheet = 1)
}
\arguments{
\item{file}{This is the path to a xlsx or csv file containing data for the
following types of plates: 6, 12, 24, 48, 96, 384, and 1536. The plate format
is described below.}

\item{well_id}{This is takes a character of length 1 and cannot be the
same as individual plate names.}

\item{sheet}{If file type is xlsx this is the sheet name (character) or
number (integer).}
}
\value{
An error or a message saying that input file can be used with the
\code{tidy_plate()} function
}
\description{
Checks whether the input file can be used to transform to a tidy plate using
the \code{tidy_plate()} function
}
\examples{
file_path <- system.file(
  "extdata",
  "example_12_well.xlsx",
  package = "tidyplate"
)

check_plate(file = file_path)
}
