% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_gam_predictions}
\alias{get_gam_predictions}
\title{Get predictions from a GAM model.}
\usage{
get_gam_predictions(
  model,
  series,
  series_length = 25,
  conditions = NULL,
  exclude_random = TRUE,
  exclude_terms = NULL,
  split = NULL,
  sep = "\\\\.",
  time_series,
  transform = NULL,
  ci_z = 1.96,
  .comparison = NULL
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{series}{An unquoted expression indicating the model term that defines the series on which smoothing is applied. This is the term that is displayed on the x-axis when plotting.}

\item{series_length}{An integer indicating how many values along the time series to use for predicting the outcome term.}

\item{conditions}{A list of quosures with \code{quos} specifying the levels to plot from the model terms.}

\item{exclude_random}{Whether to exclude random smooths (the default is \code{TRUE}).}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names should be given as they appear in the model summary (for example, \code{"s(x0,x1)"}).}

\item{split}{Columns to separate as a named list.}

\item{sep}{Separator between columns (default is \code{"\\."}, which is the default with \code{}). If character, it is interpreted as a regular expression.}

\item{time_series}{Deprecated, use \code{series} instead.}

\item{transform}{Function used to transform the fitted values (useful for getting plots on the response scale).}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for 95 percent CI).}

\item{.comparison}{Internal parameter, passed from plot_smooths().}
}
\value{
A tibble with predictions from a \link[mgcv]{gam} or \link[mgcv]{bam} model.
}
\description{
It returns a tibble with the predictions from a \link[mgcv]{gam} or \link[mgcv]{bam} object.
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac) + s(x0), data = data)

pred <- get_gam_predictions(model, x2)

}
