% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_difference}
\alias{plot_difference}
\title{Plot difference smooth from a GAM.}
\usage{
plot_difference(model, series, difference, conditions = NULL,
  exclude_random = TRUE, series_length = 100, time_series)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{series}{An unquoted expression indicating the model term that defines the series on which smoothing is applied. This is the term that is displayed on the x-axis when plotting.}

\item{difference}{A named list with the levels to compute the difference of.}

\item{conditions}{A named list specifying the levels to plot from the model terms not among \code{series} or \code{difference}. Notice the difference with \link[tidymv]{plot_smooths}, which uses \link[rlang]{quos}.}

\item{exclude_random}{Whether to exclude random smooths (the default is \code{TRUE}).}

\item{series_length}{An integer indicating how many values along the time series to use for predicting the outcome term.}

\item{time_series}{Deprecated, use \code{series} instead.}
}
\description{
It plots the difference smooth from a \link[mgcv]{gam} or \link[mgcv]{bam}.
Significant differences are marked with red areas.
}
\examples{
library(mgcv)
set.seed(10)
data <- gamSim(4)
model <- gam(y ~ fac + s(x2) + s(x2, by = fac) + s(x0), data = data)

plot_difference(model, x2, list(fac = c("1", "2")))

# For details, see vignette
\dontrun{
vignette("plot-smooths", package = "tidymv")
}

}
