% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_funs.R
\name{impute_functions}
\alias{impute_functions}
\alias{impute_explicit}
\alias{impute_explicit_at}
\alias{impute_explicit_all}
\alias{impute_explicit_if}
\alias{impute_zero}
\alias{impute_zero_at}
\alias{impute_zero_all}
\alias{impute_zero_if}
\alias{impute_inf}
\alias{impute_inf_at}
\alias{impute_inf_all}
\alias{impute_inf_if}
\alias{impute_neginf}
\alias{impute_neginf_at}
\alias{impute_neginf_all}
\alias{impute_neginf_if}
\alias{impute_constant}
\alias{impute_constant_at}
\alias{impute_constant_all}
\alias{impute_constant_if}
\alias{impute_max}
\alias{impute_max_at}
\alias{impute_max_all}
\alias{impute_max_if}
\alias{impute_min}
\alias{impute_min_at}
\alias{impute_min_all}
\alias{impute_min_if}
\alias{impute_median}
\alias{impute_median_at}
\alias{impute_median_all}
\alias{impute_median_if}
\alias{impute_mean}
\alias{impute_mean_at}
\alias{impute_mean_all}
\alias{impute_mean_if}
\alias{impute_most_freq}
\alias{impute_most_freq_at}
\alias{impute_most_freq_all}
\alias{impute_most_freq_if}
\alias{impute_quantile}
\alias{impute_quantile_at}
\alias{impute_quantile_all}
\alias{impute_quantile_if}
\alias{impute_sample}
\alias{impute_sample_at}
\alias{impute_sample_all}
\alias{impute_sample_if}
\alias{impute_random}
\alias{impute_random_at}
\alias{impute_random_all}
\alias{impute_random_if}
\alias{impute_replace}
\alias{impute_replace_at}
\alias{impute_replace_all}
\alias{impute_replace_if}
\title{Table imputation methods}
\usage{
impute_functions(.tbl, .na, .vars, .predicate)
}
\arguments{
\item{.tbl}{table-like or list-like structure}

\item{.na}{value/function to be used for replacement}

\item{.vars}{list of columns generated by vars(), or a character vector of
column names, or a numeric vector of column positions.}

\item{.predicate}{A predicate function to be applied to the columns or a
logical vector.}

\item{...}{addition passed to the imputation method}
}
\description{
Replace missing value methods with a variety of methods
}
\details{
These methods are modelled closely after \code{\link[dplyr:mutate]{dplyr::mutate()}} and the select
style verbs. Most of the functions depend on the \strong{na.tools} package.

Function List:
\itemize{
\item explicit: \code{impute_explicit}, \code{impute_explicit_at}, \code{impute_explicit_all}, \code{impute_explicit_if}
\item zero: \code{impute_zero}, \code{impute_zero_at}, \code{impute_zero_all}, \code{impute_zero_if}
\item inf: \code{impute_inf}, \code{impute_inf_at}, \code{impute_inf_all}, \code{impute_inf_if}
\item neginf: \code{impute_neginf}, \code{impute_neginf_at}, \code{impute_neginf_all}, \code{impute_neginf_if}
\item constant: \code{impute_constant}, \code{impute_constant_at}, \code{impute_constant_all}, \code{impute_constant_if}
\item max: \code{impute_max}, \code{impute_max_at}, \code{impute_max_all}, \code{impute_max_if}
\item min: \code{impute_min}, \code{impute_min_at}, \code{impute_min_all}, \code{impute_min_if}
\item median: \code{impute_median}, \code{impute_median_at}, \code{impute_median_all}, \code{impute_median_if}
\item mean: \code{impute_mean}, \code{impute_mean_at}, \code{impute_mean_all}, \code{impute_mean_if}
\item most_freq: \code{impute_most_freq}, \code{impute_most_freq_at}, \code{impute_most_freq_all}, \code{impute_most_freq_if}
\item quantile: \code{impute_quantile}, \code{impute_quantile_at}, \code{impute_quantile_all}, \code{impute_quantile_if}
\item sample: \code{impute_sample}, \code{impute_sample_at}, \code{impute_sample_all}, \code{impute_sample_if}
\item random: \code{impute_random}, \code{impute_random_at}, \code{impute_random_all}, \code{impute_random_if}
\item replace: \code{impute_replace}, \code{impute_replace_at}, \code{impute_replace_all}, \code{impute_replace_if}
}
}
\examples{

 \dontrun{ 
  nacars \%>\% impute_zero() 
  nacars \%>\% impute_zero( mpg, cyl )
  nacars \%>\% impute_zero( "mpg", "cyl" )
  nacars \%>\% impute_zero( c("mpg","cyl") )
  nacars \%>\% impute_zero( 1:2 )
 }
}
