# context("centrality")
#
get_cent <- function(gr, fn) {
  gr %>% mutate(cent = fn) %>% pull(cent)
}
test_that("centrality returns numeric", {
  gr1 <- create_notable('diamond')
  expect_is(get_cent(gr1, centrality_alpha()), 'numeric')
  expect_is(get_cent(gr1, centrality_betweenness()), 'numeric')
  expect_is(get_cent(gr1, centrality_closeness()), 'numeric')
  expect_is(get_cent(gr1, centrality_degree()), 'numeric')
  expect_is(get_cent(gr1, centrality_pagerank()), 'numeric')
  expect_is(get_cent(gr1, centrality_power()), 'numeric')
  expect_is(get_cent(gr1, centrality_subgraph()), 'numeric')
  gr2 <- activate(gr1, 'edges')
  expect_is(get_cent(gr2, centrality_edge_betweenness()), 'numeric')

  skip_on_os('windows')
  expect_is(get_cent(gr1, centrality_authority()), 'numeric')
  expect_is(get_cent(gr1, centrality_eigen()), 'numeric')
  expect_is(get_cent(gr1, centrality_hub()), 'numeric')
})
test_that("centrality returns correct length", {
  gr1 <- create_notable('diamond')
  expect_length(get_cent(gr1, centrality_alpha()), 4)
  expect_length(get_cent(gr1, centrality_betweenness()), 4)
  expect_length(get_cent(gr1, centrality_closeness()), 4)
  expect_length(get_cent(gr1, centrality_degree()), 4)
  expect_length(get_cent(gr1, centrality_pagerank()), 4)
  expect_length(get_cent(gr1, centrality_power()), 4)
  expect_length(get_cent(gr1, centrality_subgraph()), 4)
  gr2 <- activate(gr1, 'edges')
  expect_length(get_cent(gr2, centrality_edge_betweenness()), 5)

  skip_on_os('windows')
  expect_length(get_cent(gr1, centrality_authority()), 4)
  expect_length(get_cent(gr1, centrality_eigen()), 4)
  expect_length(get_cent(gr1, centrality_hub()), 4)
})
test_that("centrality requires the right activation", {
  gr1 <- create_notable('diamond')
  expect_error(get_cent(gr1, centrality_edge_betweenness()))
  gr2 <- activate(gr1, 'edges')
  expect_error(get_cent(gr2, centrality_alpha()))
  expect_error(get_cent(gr2, centrality_betweenness()))
  expect_error(get_cent(gr2, centrality_closeness()))
  expect_error(get_cent(gr2, centrality_degree()))
  expect_error(get_cent(gr2, centrality_pagerank()))
  expect_error(get_cent(gr2, centrality_power()))
  expect_error(get_cent(gr2, centrality_subgraph()))

  skip_on_os('windows')
  expect_error(get_cent(gr2, centrality_authority()))
  expect_error(get_cent(gr2, centrality_eigen()))
  expect_error(get_cent(gr2, centrality_hub()))
})
