% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_processing.R
\name{extract_results}
\alias{extract_results}
\title{Extract forward geocoding results}
\usage{
extract_results(
  method,
  response,
  full_results = TRUE,
  flatten = TRUE,
  limit = 1
)
}
\arguments{
\item{method}{method name}

\item{response}{content from the geocoding service (returned by the \link{query_api} function)}

\item{full_results}{if TRUE then the full results (not just latitude and longitude)
will be returned.}

\item{flatten}{if TRUE then flatten any nested dataframe content}

\item{limit}{only used for "census" and "google" methods. Limits number of results per address.}
}
\value{
geocoding results in tibble format
}
\description{
Parses the output of the \link{query_api} function for single
address geocoding (ie. not batch geocoding).
Latitude and longitude are extracted into the first two columns
of the returned dataframe.  Refer to  \link{query_api} for example
usage.
}
\seealso{
\link{get_api_query} \link{query_api} \link{geo}
}
