% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results_processing.R
\name{extract_reverse_results}
\alias{extract_reverse_results}
\title{Extract reverse geocoding results}
\usage{
extract_reverse_results(
  method,
  response,
  full_results = TRUE,
  flatten = TRUE,
  limit = 1
)
}
\arguments{
\item{method}{method name}

\item{response}{content from the geocoder service (returned by the \link{query_api} function)}

\item{full_results}{if TRUE then the full results (not just an address column)
will be returned.}

\item{flatten}{if TRUE then flatten any nested dataframe content}

\item{limit}{only used for the "google"
method(s). Limits number of results per coordinate.}
}
\value{
geocoder results in tibble format
}
\description{
Parses the output of the \link{query_api} function for reverse geoocding.
The address is extracted into the first column
of the returned dataframe. This function is not used for batch
geocoded results. Refer to \link{query_api} for example
usage.
}
\seealso{
\link{get_api_query} \link{query_api} \link{reverse_geo}
}
