% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\title{Geocode street addresses in a dataframe}
\usage{
geocode(.tbl, address, method = "census", lat = lat, long = long,
  ...)
}
\arguments{
\item{.tbl}{dataframe}

\item{address}{name of column containing addresses in .tbl}

\item{method}{the geocoder function you want to use
\itemize{
  \item "census": \code{\link{geo_census}} - can only handle US street level addresses
  \item "osm": \code{\link{geo_osm}} - more versatile than Census but has a usage limit
  \item "cascade": \code{\link{geo_cascade}} - first tries to use census then tries osm
}}

\item{lat}{name of latitude field}

\item{long}{name of longitude field}

\item{...}{arguments supplied to the relevant geocoder function}
}
\value{
input dataframe (.tbl) with latitude and longitude fields appended
}
\description{
Takes a dataframe containing addresses as a input. Returns
the dataframe with latitude and longitude coordinate columns
using a user specified geocoder function.
}
\details{
See example usage in \code{vignette("tidygeocoder")}
}
\examples{
\donttest{
sample_addresses \%>\% geocode(addr)

sample_addresses \%>\% geocode(addr,method='cascade',lat=latitude,long=longitude)
}
}
