% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_dt.R
\name{summarise_dt}
\alias{summarise_dt}
\alias{summarize_dt}
\alias{summarise_when}
\alias{summarize_when}
\alias{summarise_vars}
\alias{summarize_vars}
\title{Summarise columns to single values}
\usage{
summarise_dt(.data, ..., by = NULL)

summarize_dt(.data, ..., by = NULL)

summarise_when(.data, when, ..., by = NULL)

summarize_when(.data, when, ..., by = NULL)

summarise_vars(.data, .cols = NULL, .func, ..., by)

summarize_vars(.data, .cols = NULL, .func, ..., by)
}
\arguments{
\item{.data}{data.frame}

\item{...}{List of variables or name-value pairs of summary/modifications
functions for \code{summarise_dt}.Additional parameters to be passed to
 parameter '.func' in \code{summarise_vars}.}

\item{by}{unquoted name of grouping variable of list of unquoted names of
grouping variables. For details see \link[data.table]{data.table}}

\item{when}{An object which can be coerced to logical mode}

\item{.cols}{Columns to be summarised.}

\item{.func}{Function to be run within each column, should return a value or vectors with same length.}
}
\value{
data.table
}
\description{
Summarise group of values into one value for each group. If there is only one group, then only one value would be returned.
 The summarise function should always return a single value.
}
\details{
\code{summarise_vars} could complete summarise on specific columns.
}
\examples{
iris \%>\% summarise_dt(avg = mean(Sepal.Length))
iris \%>\% summarise_dt(avg = mean(Sepal.Length),by = Species)
mtcars \%>\% summarise_dt(avg = mean(hp),by = .(cyl,vs))

# the data.table way
mtcars \%>\% summarise_dt(cyl_n = .N, by = .(cyl, vs)) # `.` is short for list

iris \%>\% summarise_vars(is.numeric,min)
iris \%>\% summarise_vars(-is.factor,min)
iris \%>\% summarise_vars(1:4,min)

iris \%>\% summarise_vars(is.numeric,min,by ="Species")
mtcars \%>\% summarise_vars(is.numeric,mean,by = "vs,am")

# use multiple functions on multiple columns
iris \%>\%
  summarise_vars(is.numeric,.func = list(mean,sd,median))
iris \%>\%
  summarise_vars(is.numeric,.func = list(mean,sd,median),by = Species)

}
\seealso{
\code{\link[dplyr]{summarise}}
}
