% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice_dt}
\alias{slice_dt}
\alias{slice_head_dt}
\alias{slice_tail_dt}
\alias{slice_max_dt}
\alias{slice_min_dt}
\alias{slice_sample_dt}
\title{Subset rows using their positions}
\usage{
slice_dt(.data, ...)

slice_head_dt(.data, n)

slice_tail_dt(.data, n)

slice_max_dt(.data, order_by, n, with_ties = TRUE)

slice_min_dt(.data, order_by, n, with_ties = TRUE)

slice_sample_dt(.data, n, replace = FALSE)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.}

\item{n}{When larger than or equal to 1, the number of rows.
When between 0 and 1, the proportion of rows to select.}

\item{order_by}{Variable or function of variables to order by.}

\item{with_ties}{Should ties be kept together? The default, `TRUE`,
may return more rows than you request. Use `FALSE` to ignore ties,
and return the first `n` rows.}

\item{replace}{Should sampling be performed with (`TRUE`) or without
(`FALSE`, the default) replacement.}
}
\value{
A data.table
}
\description{
`slice_dt()` lets you index rows by their (integer) locations. It allows you
to select, remove, and duplicate rows. It is accompanied by a number of
helpers for common use cases:

* `slice_head_dt()` and `slice_tail_dt()` select the first or last rows.
* `slice_sample_dt()` randomly selects rows.
* `slice_min_dt()` and `slice_max_dt()` select rows with highest or lowest values
  of a variable.
}
\examples{

a = iris
slice_dt(a,1,2)
slice_dt(a,2:3)
slice_head_dt(a,5)
slice_head_dt(a,0.1)
slice_tail_dt(a,5)
slice_tail_dt(a,0.1)
slice_max_dt(a,Sepal.Length,10)
slice_max_dt(a,Sepal.Length,10,with_ties = FALSE)
slice_min_dt(a,Sepal.Length,10)
slice_min_dt(a,Sepal.Length,10,with_ties = FALSE)
slice_sample_dt(a,10)
slice_sample_dt(a,0.1)

}
\seealso{
\code{\link[dplyr]{slice}}
}
