% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.spikeslab.R
\name{.fit.spikeslab}
\alias{.fit.spikeslab}
\title{Bayesian Spike and Slab regression or classification for \code{tidyfit}}
\usage{
\method{.fit}{spikeslab}(self, data = NULL)
}
\arguments{
\item{self}{a tidyFit R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted tidyFit class model.
}
\description{
Fits a Bayesian Spike and Slab regression or classification on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

In the case of \strong{regression}, arguments are passed to \code{BoomSpikeSlab::lm.spike} and \code{BoomSpikeSlab::SpikeSlabPrior}. Check those functions for details.

\code{BoomSpikeSlab::SpikeSlabPrior}
\itemize{
\item expected.r2
\item prior.df
\item expected.model.size
}

\code{BoomSpikeSlab::lm.spike}
\itemize{
\item niter
}

In the case of \strong{classification}, arguments are passed to \code{BoomSpikeSlab::logit.spike} and \code{BoomSpikeSlab::SpikeSlabGlmPrior}. Check those functions for details.

\code{BoomSpikeSlab::logit.spike}
\itemize{
\item niter
}

I advise against the use of \code{BoomSpikeSlab::SpikeSlabGlmPrior} at the moment, since it appears to be buggy.

The function provides wrappers for \code{BoomSpikeSlab::lm.spike} and \code{BoomSpikeSlab::logit.spike}. See \code{?lm.spike} and \code{?logit.spike} for more details.

\strong{Implementation}

Prior arguments are passed to \code{BoomSpikeSlab::SpikeSlabPrior} and \code{BoomSpikeSlab::SpikeSlabGlmPrior} (the function automatically identifies which arguments are for the prior, and which for \code{BoomSpikeSlab::lm.spike} or \code{BoomSpikeSlab::logit.spike}).

\code{BoomSpikeSlab::logit.spike} is automatically selected when using \code{classify}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("spikeslab", Return ~ ., data, niter = 100)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("spikeslab", niter = 100),
               .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Scott SL (2022). \emph{BoomSpikeSlab: MCMC for Spike and Slab Regression}. R package version 1.2.5, \url{https://CRAN.R-project.org/package=BoomSpikeSlab}.
}
\seealso{
\code{\link{.fit.lasso}}, \code{\link{.fit.blasso}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
