% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.chisq.R
\name{.model.chisq}
\alias{.model.chisq}
\title{Pearson's Chi-squared test for \code{tidyfit}}
\usage{
\method{.model}{chisq}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Calculates Pearson's Chi-squared test on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{stats::chisq.test}. See \code{?chisq.test} for more details.

\strong{Implementation}

Results can be viewed using \code{coef}.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::mutate_at(data, dplyr::vars(-Date, -Industry), dplyr::ntile, n = 10)

# Within 'classify' function
fit <- classify(data, Return ~ ., m("chisq"), .mask = c("Date", "Industry"))
tidyr::unnest(coef(fit), model_info)

}
\seealso{
\code{\link{.model.cor}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
