% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_dann.R
\name{tidy_dann}
\alias{tidy_dann}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
tidy_dann(
  mode = "classification",
  neighbors = NULL,
  neighborhood = NULL,
  epsilon = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{neighbors}{The number of data points used for final classification.}

\item{neighborhood}{The number of data points used to calculate between and
within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity
matrix.}
}
\value{
An S3 class of type tidy_dann.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
Discriminant Adaptive Nearest Neighbor (dann) is a variation of k nearest
neighbors where the shape of the neighborhood is data driven. The
neighborhood is elongated along class boundaries and shrunk in the orthogonal
direction.

The only engine for this model is dann.
}
\examples{

library(rsample)
library(parsnip)
library(tidydann)

data("two_class_dat", package = "modeldata")
set.seed(1)
example_split <- initial_split(two_class_dat, prop = 0.99)
example_train <- training(example_split)
example_test <- testing(example_split)

model <- tidy_dann(neighbors = 2) |>
  set_engine("dann") |>
  fit(formula = Class ~ A + B, data = example_train)

model |>
  predict(new_data = example_test)

}
