% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips_codes.R
\docType{data}
\name{fips_codes}
\alias{fips_codes}
\title{Dataset with FIPS codes for US states and counties}
\format{An object of class \code{data.frame} with 3237 rows and 5 columns.}
\usage{
data(fips_codes)
}
\description{
Built-in dataset for smart state and county lookup.
             To access the data directly, issue the command \code{data(fips_codes)}.

\itemize{
  \item \code{county}: County name, title-case
  \item \code{county_code}: County code. (3-digit, 0-padded, character)
  \item \code{state}: Upper-case abbreviation of state
  \item \code{state_code}: State FIPS code (2-digit, 0-padded, character)
  \item \code{state_name}: Title-case name of state
}
}
\details{
Dataset with FIPS codes for US states and counties

Built-in dataset for use with the \code{lookup_code} function.
To access the data directly, issue the command \code{data(fips_codes)}.

Note: this dataset includes FIPS codes for all counties that have appeared in
the decennial Census or American Community Survey from 2010 to the present.
This means that counties that have been renamed or absorbed into other
geographic entities since 2010 remain in this dataset along with newly added
or renamed counties.

If you need the FIPS codes and names for counties for a particular Census
year, you can use the \link[tigris]{counties} function from the tigris
package and set the year parameter as required.
}
\keyword{datasets}
