% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epred_draws.R, R/linpred_draws.R,
%   R/predicted_draws.R, R/residual_draws.R
\name{add_epred_draws}
\alias{add_epred_draws}
\alias{epred_draws}
\alias{epred_draws.default}
\alias{epred_draws.stanreg}
\alias{epred_draws.brmsfit}
\alias{add_linpred_draws}
\alias{linpred_draws}
\alias{linpred_draws.default}
\alias{linpred_draws.stanreg}
\alias{linpred_draws.brmsfit}
\alias{add_predicted_draws}
\alias{predicted_draws}
\alias{predicted_draws.default}
\alias{predicted_draws.stanreg}
\alias{predicted_draws.brmsfit}
\alias{add_residual_draws}
\alias{residual_draws}
\alias{residual_draws.default}
\alias{residual_draws.brmsfit}
\title{Add draws from the posterior fit, predictions, or residuals of a model to a data frame}
\usage{
add_epred_draws(
  newdata,
  object,
  ...,
  value = ".epred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

epred_draws(
  object,
  newdata,
  ...,
  value = ".epred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

\method{epred_draws}{default}(
  object,
  newdata,
  ...,
  value = ".epred",
  seed = NULL,
  category = NULL
)

\method{epred_draws}{stanreg}(
  object,
  newdata,
  ...,
  value = ".epred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

\method{epred_draws}{brmsfit}(
  object,
  newdata,
  ...,
  value = ".epred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

add_linpred_draws(
  newdata,
  object,
  ...,
  value = ".linpred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL,
  n
)

linpred_draws(
  object,
  newdata,
  ...,
  value = ".linpred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL,
  n,
  scale
)

\method{linpred_draws}{default}(
  object,
  newdata,
  ...,
  value = ".linpred",
  seed = NULL,
  category = NULL
)

\method{linpred_draws}{stanreg}(
  object,
  newdata,
  ...,
  value = ".linpred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

\method{linpred_draws}{brmsfit}(
  object,
  newdata,
  ...,
  value = ".linpred",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  dpar = NULL
)

add_predicted_draws(
  newdata,
  object,
  ...,
  value = ".prediction",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  n
)

predicted_draws(
  object,
  newdata,
  ...,
  value = ".prediction",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  n,
  prediction
)

\method{predicted_draws}{default}(
  object,
  newdata,
  ...,
  value = ".prediction",
  seed = NULL,
  category = ".category"
)

\method{predicted_draws}{stanreg}(
  object,
  newdata,
  ...,
  value = ".prediction",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category"
)

\method{predicted_draws}{brmsfit}(
  object,
  newdata,
  ...,
  value = ".prediction",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category"
)

add_residual_draws(
  newdata,
  object,
  ...,
  value = ".residual",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  n
)

residual_draws(
  object,
  newdata,
  ...,
  value = ".residual",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category",
  n,
  residual
)

\method{residual_draws}{default}(object, newdata, ...)

\method{residual_draws}{brmsfit}(
  object,
  newdata,
  ...,
  value = ".residual",
  ndraws = NULL,
  seed = NULL,
  re_formula = NULL,
  category = ".category"
)
}
\arguments{
\item{newdata}{Data frame to generate predictions from.}

\item{object}{A supported Bayesian model fit that can provide fits and predictions. Supported models
are listed in the second section of \link{tidybayes-models}: \emph{Models Supporting Prediction}. While other
functions in this package (like \code{\link[=spread_draws]{spread_draws()}}) support a wider range of models, to work with
\code{add_epred_draws()}, \code{add_predicted_draws()}, etc. a model must provide an interface for generating
predictions, thus more generic Bayesian modeling interfaces like \code{runjags} and \code{rstan} are not directly
supported for these functions (only wrappers around those languages that provide predictions, like \code{rstanarm}
and \code{brm}, are supported here).}

\item{...}{Additional arguments passed to the underlying prediction method for the type of
model given.}

\item{value}{The name of the output column:
\itemize{
\item for \verb{[add_]epred_draws()}, defaults to \code{".epred"}.
\item for \verb{[add_]predicted_draws()}, defaults to \code{".prediction"}.
\item for \verb{[add_]linpred_draws()}, defaults to \code{".linpred"}.
\item for \verb{[add_]residual_draws()}, defaults to \code{".residual"}
}}

\item{ndraws}{The number of draws to return, or \code{NULL} to return all draws.}

\item{seed}{A seed to use when subsampling draws (i.e. when \code{ndraws} is not \code{NULL}).}

\item{re_formula}{formula containing group-level effects to be considered in the prediction.
If \code{NULL} (default), include all group-level effects; if \code{NA}, include no group-level effects.
Some model types (such as \link[brms:brmsfit-class]{brms::brmsfit} and \link[rstanarm:stanreg-objects]{rstanarm::stanreg-objects}) allow
marginalizing over grouping factors by specifying new levels of a factor in \code{newdata}. In the case of
\code{\link[brms:brm]{brms::brm()}}, you must also pass \code{allow_new_levels = TRUE} here to include new levels (see
\code{\link[brms:posterior_predict.brmsfit]{brms::posterior_predict()}}).}

\item{category}{For \emph{some} ordinal, multinomial, and multivariate models (notably, \code{\link[brms:brm]{brms::brm()}} models but
\emph{not} \code{\link[rstanarm:stan_polr]{rstanarm::stan_polr()}} models), multiple sets of rows will be returned per input row for
\code{epred_draws()} or \code{predicted_draws()}, depending on the model type. For ordinal/multinomial models,
these rows correspond to different categories of the response variable. For multivariate models, these correspond to
different response variables. The \code{category} argument specifies the name of the column
to put the category names (or variable names) into in the resulting data frame. The default name of this column
(\code{".category"}) reflects the fact that this functionality was originally used only for ordinal models and
has been re-used for multivariate models. The fact that multiple rows per response are returned only for some
model types reflects the fact that tidybayes takes the approach of tidying whatever output is given to us, and
the output from different modeling functions differs on this point.
See \code{vignette("tidy-brms")} and \code{vignette("tidy-rstanarm")} for examples of dealing with output
from ordinal models using both approaches.}

\item{dpar}{For \code{add_epred_draws()} and \code{add_linpred_draws()}: Should distributional regression
parameters be included in the output? Valid only for models that support distributional regression parameters,
such as submodels for variance parameters (as in \code{brms::brm()}). If \code{TRUE}, distributional regression
parameters are included in the output as additional columns named after each parameter
(alternative names can be provided using a list or named vector, e.g. \code{c(sigma.hat = "sigma")}
would output the \code{"sigma"} parameter from a model as a column named \code{"sigma.hat"}).
If \code{NULL} or \code{FALSE} (the default), distributional regression parameters are not included.}

\item{n}{(Deprecated). Use \code{ndraws}.}

\item{scale}{(Deprecated). Use the appropriate function (\code{epred_draws()} or \code{linpred_draws()})
depending on what type of distribution you want. For \code{linpred_draws()}, you may want the
\code{transform} argument. See \code{rstanarm::posterior_linpred()} or \code{brms::posterior_linpred()}.}

\item{prediction, residual}{(Deprecated). Use \code{value}.}
}
\value{
A data frame (actually, a \link[tibble:tibble]{tibble}) with a \code{.row} column (a
factor grouping rows from the input \code{newdata}), \code{.chain} column (the chain
each draw came from, or \code{NA} if the model does not provide chain information),
\code{.iteration} column (the iteration the draw came from, or \code{NA} if the model does
not provide iteration information), and a \code{.draw} column (a unique index corresponding to each draw
from the distribution). In addition, \code{epred_draws} includes a column with its name specified by
the \code{epred} argument (default \code{".epred"}); \code{linpred_draws} includes a column with its name
specified by the \code{linpred} argument (default \code{".linpred"}), and
\code{predicted_draws} contains a column with its name specified by the \code{.prediction} argument (default
\code{".prediction"}). For convenience, the resulting data frame comes grouped by the original input rows.
}
\description{
Given a data frame and a model, adds draws from the linear/link-level predictor,
the expectation of the posterior predictive, the posterior predictive, or the residuals of a model to
the data frame in a long format.
}
\details{
\code{add_epred_draws()} adds draws from \strong{expectation} of the posterior predictive distribution to
the data.
It corresponds to \code{\link[rstanarm:posterior_linpred.stanreg]{rstanarm::posterior_epred()}} or \code{\link[brms:posterior_epred.brmsfit]{brms::posterior_epred()}}.

\code{add_predicted_draws()} adds draws from posterior predictive distribution to
the data.
It corresponds to \code{\link[rstanarm:posterior_predict.stanreg]{rstanarm::posterior_predict()}} or \code{\link[brms:posterior_predict.brmsfit]{brms::posterior_predict()}}.

\code{add_linpred_draws()} adds draws from (possibly transformed) posterior \strong{linear}
predictors (or "link-level" predictors) to the data.
It corresponds to \code{\link[rstanarm:posterior_linpred.stanreg]{rstanarm::posterior_linpred()}} or \code{\link[brms:posterior_linpred.brmsfit]{brms::posterior_linpred()}}.

\code{add_residual_draws()} adds draws from residuals to the data.
It corresponds to \code{\link[brms:residuals.brmsfit]{brms::residuals.brmsfit()}}.

The corresponding functions without \code{add_} as a prefix are alternate spellings
with the opposite order of the first two arguments: e.g. \code{add_predicted_draws()}
and \code{predicted_draws()}. This facilitates use in data
processing pipelines that start either with a data frame or a model.

Given equal choice between the two, the spellings prefixed with \code{add_}
are preferred.
}
\examples{
\dontshow{if (requireNamespace("brms", quietly = TRUE) && requireNamespace("modelr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

library(ggplot2)
library(dplyr)
library(brms)
library(modelr)

theme_set(theme_light())

m_mpg = brm(mpg ~ hp * cyl, data = mtcars,
  # 1 chain / few iterations just so example runs quickly
  # do not use in practice
  chains = 1, iter = 500)

# draw 100 lines from the posterior means and overplot them
mtcars \%>\%
  group_by(cyl) \%>\%
  data_grid(hp = seq_range(hp, n = 101)) \%>\%
  # NOTE: only use ndraws here when making spaghetti plots; for
  # plotting intervals it is always best to use all draws (omit ndraws)
  add_epred_draws(m_mpg, ndraws = 100) \%>\%
  ggplot(aes(x = hp, y = mpg, color = ordered(cyl))) +
  geom_line(aes(y = .epred, group = paste(cyl, .draw)), alpha = 0.25) +
  geom_point(data = mtcars)

# plot posterior predictive intervals
mtcars \%>\%
  group_by(cyl) \%>\%
  data_grid(hp = seq_range(hp, n = 101)) \%>\%
  add_predicted_draws(m_mpg) \%>\%
  ggplot(aes(x = hp, y = mpg, color = ordered(cyl))) +
  stat_lineribbon(aes(y = .prediction), .width = c(.99, .95, .8, .5), alpha = 0.25) +
  geom_point(data = mtcars) +
  scale_fill_brewer(palette = "Greys")

}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=add_draws]{add_draws()}} for the variant of these functions for use with packages that do not have
explicit support for these functions yet. See \code{\link[=spread_draws]{spread_draws()}} for manipulating posteriors directly.
}
\author{
Matthew Kay
}
\keyword{manip}
