% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_chisq.R
\name{micro_chisq}
\alias{micro_chisq}
\title{Run Chi-Squared tests for each taxa}
\usage{
micro_chisq(micro_set, table, grp_var, y = bin, mod = NULL, ...)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{table}{The OTU table you'd like to test}

\item{grp_var}{Grouping variable for chi-squared test}

\item{y}{Response variable for chi-squared test. Default is presence / absence (bin)}

\item{mod}{The output from mods if you'd like to only run on taxa that did not converge}

\item{...}{Options to be passed to chisq.test}
}
\value{
A data from containing the taxa, the chi-squared statistic, and the p-value of the test.
}
\description{
Run Chi-Squared tests for presence / absence of each taxa in you data set, or each taxa that didn't converge in negative binomial models
}
\details{
If the taxa are present or absent in every subject the chi-sqared test will not but run. The returned chi-sqared stat will either be "All Absent" or "All Present." This will be clear in the output
}
\examples{
data(cla); data(clin)

set <- tidy_micro(otu_tabs = cla, tab_names = "Class", clinical = clin,
prev_cutoff = 5, ra_cutoff = 0.1, exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
filter(day == 7) ## Only including the first week

## Chi-squared test on every taxa's presence/absence
set \%>\% micro_chisq(table = "Class", grp_var = bpd1,
simulate.p.value = TRUE)

## Chi-squared test on every taxa whose model didn't converge
nb_cla <- set \%>\% nb_mods(table = "Class", bpd1)

micro_chisq(micro_set = set, table = "Class", grp_var = bpd1,
mod = nb_cla, simulate.p.value = TRUE)
}
\references{
\code{help(chisq.test)}
}
