% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.summary.mc}
\alias{plot.summary.mc}
\title{Plot the summarized results of a Monte Carlo Simulation}
\usage{
\method{plot}{summary.mc}(
  x,
  join = NULL,
  which_setup = NULL,
  parameter_comb = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.mc}. For restrictions see details.}

\item{join}{A character vector containing the \code{nice_names} for the different
parameter combinations (returned by \code{\link[=future_mc]{future_mc()}}),
which should be plotted together.
Default: Each parameter combination is plotted distinct.}

\item{which_setup}{A character vector containing the \code{nice_names}
for the different parameter
combinations (returned by \code{\link[=future_mc]{future_mc()}}), which should be plotted.
Default: All parameter combinations are plotted.}

\item{parameter_comb}{Alternative to \code{which_setup}.
A named list whose components are named after
(some of) the parameters in \code{param_list} in \code{\link[=future_mc]{future_mc()}}
and each component is a vector containing
the values for the parameters to filter by.
Default: All parameter combinations are plotted.}

\item{plot}{Boolean that specifies whether the plots
should be printed while calling the function or not.
Default: TRUE}

\item{...}{additional arguments passed to callies.}
}
\value{
A list whose components are named after the outputs of \code{fun}
and each component
contains an object of class \code{ggplot} and \code{gg} which can be plotted
and modified with the
\link{ggplot2} functions.
}
\description{
Plot line plots of the path of the summarized output
over all simulation repetitions
of a Monte Carlo simulation run by
\code{\link[=future_mc]{future_mc()}} and summarized by \code{\link[=summary.mc]{summary.mc()}}
}
\details{
Only one of the arguments \code{join}, \code{which_setup}, and \code{paramter_comb}
can be specified at a time.

A plot is only created for (output - parameter combination)-pairs
for which in \code{\link[=summary.mc]{summary.mc()}}
a function is provided in \code{sum_funs}
which returns a single numeric value and if the output
is included in \code{which_path}.
}
\examples{
test_func <- function(param = 0.1, n = 100, x1 = 1, x2 = 2){

  data <- rnorm(n, mean = param) + x1 + x2
  stat <- mean(data)
  stat_2 <- var(data)

  if (x2 == 5){
    stop("x2 can't be 5!")
  }

  return(list(mean = stat, var = stat_2))
}

param_list <- list(param = seq(from = 0, to = 1, by = 0.5),
                   x1 = 1:2)

set.seed(101)
test_mc <- future_mc(
  fun = test_func,
  repetitions = 1000,
  param_list = param_list,
  n = 10,
  x2 = 2
)

returned_plot1 <- plot(summary(test_mc))

returned_plot1$mean +
 ggplot2::theme_minimal()

returned_plot2 <- plot(summary(test_mc),
which_setup = test_mc$nice_names[1:2], plot = FALSE)
returned_plot2$mean

returned_plot3 <- plot(summary(test_mc),
join = test_mc$nice_names[1:2], plot = FALSE)
returned_plot3$mean

}
