% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{layer_symbol}
\alias{layer_symbol}
\title{Adds a layers of symbols above the heatmap tiles to a `InputHeatmap`, that on evaluation creates a `ComplexHeatmap`}
\usage{
layer_symbol(.data, ..., symbol = NULL)
}
\arguments{
\item{.data}{A `InputHeatmap`}

\item{...}{Expressions that return a logical value, and are defined in terms of the variables in .data. If multiple expressions are included, they are combined with the & operator. Only rows for which all conditions evaluate to TRUE are kept.}

\item{symbol}{NOT IMPLEMENTED YET}
}
\value{
A `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`
}
\description{
layer_symbol() from a `InputHeatmap` object, adds a bar annotation layer.
}
\details{
\lifecycle{maturing}

It uses `ComplexHeatmap` as visualisation tool.
}
\examples{

library(dplyr)

hm = 
  tidyHeatmap::N52 \%>\%
  tidyHeatmap::heatmap(
    .row = symbol_ct,
    .column = UBR,
    .value = `read count normalised log`
)

hm \%>\% layer_symbol()


}
