% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{heatmap}
\alias{heatmap}
\alias{heatmap_}
\alias{heatmap,tbl-method}
\alias{heatmap,tbl_df-method}
\title{Creates a  `InputHeatmap` object from `tbl_df` on evaluation creates a `ComplexHeatmap`}
\source{
[Mangiola and Papenfuss., 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
heatmap(
  .data,
  .row,
  .column,
  .value,
  transform = NULL,
  scale = "none",
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_grouping = list(),
  .scale = NULL,
  ...
)

heatmap_(
  .data,
  .row,
  .column,
  .value,
  transform = NULL,
  scale = "none",
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_grouping = list(),
  .scale = NULL,
  ...
)

\S4method{heatmap}{tbl}(
  .data,
  .row,
  .column,
  .value,
  transform = NULL,
  scale = "none",
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_grouping = list(),
  .scale = NULL,
  ...
)

\S4method{heatmap}{tbl_df}(
  .data,
  .row,
  .column,
  .value,
  transform = NULL,
  scale = "none",
  palette_value = c("#440154FF", "#21908CFF", "#fefada"),
  palette_grouping = list(),
  .scale = NULL,
  ...
)
}
\arguments{
\item{.data}{A `tbl_df` formatted as | <.row> | <.column> | <.value> | <...> |}

\item{.row}{The name of the column vertically presented in the heatmap}

\item{.column}{The name of the column horizontally presented in the heatmap}

\item{.value}{The name of the column for the value of the element/feature pair}

\item{transform}{A function, used to transform .value row-wise (e.g., transform = log1p)}

\item{scale}{A character string. Possible values are c(\"none\", \"row\", \"column\", \"both\")}

\item{palette_value}{A character vector This is the palette that will be used as gradient for .value. For example c("red", "white", "blue"). For higher flexibility you can use circlize::colorRamp2\(c\(-2, -1, 0, 1, 2\), viridis::magma\(5\)\)}

\item{palette_grouping}{A list of character vectors. This is the list of palettes that will be used for grouping. For example list(RColorBrewer::brewer.pal(8, "Accent")) or list(c("#B3E2CD", "#FDCDAC", "#CBD5E8")) or list(c("black", "red"))}

\item{.scale}{DEPRECATED. please use scale instead \( with no dot prefix \).}

\item{...}{The arguments that will be passed to the Heatmap function of ComplexHeatmap backend}
}
\value{
A `InputHeatmap` objects that gets evaluated to a `ComplexHeatmap` object

A `InputHeatmap` object

A `InputHeatmap` object

A `InputHeatmap` object
}
\description{
heatmap() takes a tbl object and easily produces a ComplexHeatmap plot, with integration with tibble and dplyr frameworks.
}
\details{
\lifecycle{maturing}

This function takes a tbl as an input and creates a `ComplexHeatmap` plot. The information is stored in a `InputHeatmap` object that is updated along the pipe statement, for example adding annotation layers.
}
\examples{


tidyHeatmap::N52 |>
  dplyr::group_by( `Cell type`) |>
  tidyHeatmap::heatmap(
   .row = symbol_ct,
   .column = UBR,
   .value = `read count normalised log`,
  )

}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
