% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top-n-emojis.R
\name{top_n_emojis}
\alias{top_n_emojis}
\title{Getting n most popular Emojis}
\usage{
top_n_emojis(tweet_tbl, tweet_text, n = 20, duplicated_unicode = "no")
}
\arguments{
\item{tweet_tbl}{A dataframe/tibble containing tweets/text.}

\item{tweet_text}{The tweet/text column.}

\item{n}{Top \code{n} Emojis, default is 20.}

\item{duplicated_unicode}{If no repetitious Unicode, \code{no}. Otherwise,
\code{yes}. Default is \code{no}.}
}
\value{
A tibble with top \code{n} Emojis
}
\description{
When working with Tweets, counting how many times each Emoji appears in the
entire Tweet corpus is useful. This is when \code{top_n_emojis} comes into
play, and it is handy to see how Emojis are distributed across the corpus.
If a Tweet has 10 Emojis, \code{top_n_emojis} will count it 10 times and
assign each of the 10 Emojis on its respective Emoji category. What is
interesting to note is Unicodes returned by \code{top_n_emojis} could have
duplicates, meaning some Unicodes share various Emoji names. By default, this
does not happen, but users can choose \code{duplicated_unicode = 'yes'} to
obtain duplicated Unicodes.
}
\examples{
library(dplyr)
data.frame(tweets = c("I love tidyverse \U0001f600\U0001f603\U0001f603",
                      "R is my language! \U0001f601\U0001f606\U0001f605",
                      "This Tweet does not have Emoji!",
                      "Wearing a mask\U0001f637\U0001f637\U0001f637.",
                      "Emoji does not appear in all Tweets",
                      "A flag \U0001f600\U0001f3c1")) \%>\%
         top_n_emojis(tweets, n = 2)
}
