% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_meta_random.R
\name{bf_meta_random}
\alias{bf_meta_random}
\title{Bayes factor for random-effects meta-analysis}
\usage{
bf_meta_random(data, metaBMA.args = list(), ...)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used for \code{y}  and \code{SE} arguments in
\code{metaBMA::meta_random}.}

\item{metaBMA.args}{A list of additional arguments to be passed to
\code{metaBMA::meta_random}.}

\item{...}{
  Arguments passed on to \code{\link[=bf_extractor]{bf_extractor}}
  \describe{
    \item{\code{conf.level}}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{top.text}}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}
    \item{\code{output}}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}
  }}
}
\description{
Bayes factor for random-effects meta-analysis
}
\examples{

\donttest{
# setup
set.seed(123)
library(metaBMA)

# creating a dataframe
(df <-
  structure(
    .Data = list(
      study = c("1", "2", "3", "4", "5"),
      estimate = c(
        0.382047603321706,
        0.780783111514665,
        0.425607573765058,
        0.558365541235078,
        0.956473848429961
      ),
      std.error = c(
        0.0465576338644502,
        0.0330218199731529,
        0.0362834986178494,
        0.0480571500648261,
        0.062215818388157
      )
    ),
    row.names = c(NA, -5L),
    class = c("tbl_df", "tbl", "data.frame")
  ))

# to get dataframe
bf_meta_random(
  data = df,
  k = 3,
  metaBMA.args = list(iter = 500, rscale_discrete = 0.880),
  output = "dataframe"
)
}

}
