% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_ttest.R
\name{bf_ttest}
\alias{bf_ttest}
\alias{bf_one_sample_ttest}
\alias{bf_two_sample_ttest}
\title{Bayes Factor for \emph{t}-test}
\usage{
bf_ttest(
  data,
  x,
  y = NULL,
  test.value = 0,
  paired = FALSE,
  bf.prior = 0.707,
  caption = NULL,
  output = "results",
  hypothesis.text = TRUE,
  k = 2L,
  ...
)

bf_one_sample_ttest(
  data,
  x,
  y = NULL,
  test.value = 0,
  paired = FALSE,
  bf.prior = 0.707,
  caption = NULL,
  output = "results",
  hypothesis.text = TRUE,
  k = 2L,
  ...
)

bf_two_sample_ttest(
  data,
  x,
  y = NULL,
  test.value = 0,
  paired = FALSE,
  bf.prior = 0.707,
  caption = NULL,
  output = "results",
  hypothesis.text = TRUE,
  k = 2L,
  ...
)
}
\arguments{
\item{data}{for use with \code{formula}, a data frame containing all the
data}

\item{x}{Either the grouping variable from the dataframe \code{data} if it's a
two-sample \emph{t}-test or a numeric variable if it's a one-sample \emph{t}-test.}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{paired}{if \code{TRUE}, observations are paired}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{hypothesis.text}{Logical that decides whether the expression containing
result should have text to describe the hypothesis test being described.
For \code{output = "null"}, this is \code{"In favor of null: "}, otherwise
\code{"In favor of alternative: "}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Bayes Factor for \emph{t}-test
}
\details{
If \code{y} is \code{NULL}, a one-sample \emph{t}-test will be carried out,
otherwise a two-sample \emph{t}-test will be carried out.
}
\examples{

# ------------------- two-samples tests -----------------------------------

# for reproducibility
set.seed(123)
library(tidyBF)

# to get dataframe
bf_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  bf.prior = 0.880
)

# ------------------- one-samples test -----------------------------------

# to get dataframe
bf_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_oneway_anova}}
}
