% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatasetNode.R
\name{DatasetNode}
\alias{DatasetNode}
\title{A class for a single datatset reference}
\description{
A direct Dataset representation that subclasses from ThreddsNode
}
\note{
For examples see \link{CatalogNode}
}
\section{Super class}{
\code{\link[thredds:ThreddsNode]{thredds::ThreddsNode}} -> \code{DatasetNode}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{character, often the filename}

\item{\code{dataSize}}{numeric, size in bytes}

\item{\code{date}}{character, modification date}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DatasetNode$new()}}
\item \href{#method-GET}{\code{DatasetNode$GET()}}
\item \href{#method-get_url}{\code{DatasetNode$get_url()}}
\item \href{#method-list_access}{\code{DatasetNode$list_access()}}
\item \href{#method-print}{\code{DatasetNode$print()}}
\item \href{#method-clone}{\code{DatasetNode$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="browse">}\href{../../thredds/html/ThreddsNode.html#method-browse}{\code{thredds::ThreddsNode$browse()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="thredds" data-topic="ThreddsNode" data-id="children_names">}\href{../../thredds/html/ThreddsNode.html#method-children_names}{\code{thredds::ThreddsNode$children_names()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
initialize an instance of ServiceNode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$new(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{url or xml2::xml_node}

\item{\code{...}}{arguments for superclass initialization}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GET"></a>}}
\if{latex}{\out{\hypertarget{method-GET}{}}}
\subsection{Method \code{GET()}}{
Overrides the GET method of the superclass.  GET is not permitted
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$GET()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_url"></a>}}
\if{latex}{\out{\hypertarget{method-get_url}{}}}
\subsection{Method \code{get_url()}}{
Retrieve the relative URL for a dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$get_url(
  service = c("dap", "opendap", "wms")[1],
  sep = c("/", "")[2],
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{service}}{character, the service to use.  (default 'dap' equivalent to 'opendap')
Ignored if `urlPath` or `href` is in the nodes' attributes.}

\item{\code{sep}}{character, typically "/" or "" (default), used for joined base_url to relative url}

\item{\code{...}}{other arguments for \code{DatasetNode$list_access}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_access"></a>}}
\if{latex}{\out{\hypertarget{method-list_access}{}}}
\subsection{Method \code{list_access()}}{
list access methods
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$list_access(xpath = build_xpath("access", prefix = self$prefix))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xpath}}{charcater, xpath descriptor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named list of character vectors or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$print(prefix = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{character, to be printed before each line of output (like spaces)}

\item{\code{...}}{other arguments for superclass}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DatasetNode$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
