% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_ref.R
\name{download_ref}
\alias{download_ref}
\title{Download functional prediction reference tables}
\usage{
download_ref(
  destination,
  reference = c("all", "gg_ko", "gg_cog", "silva_ko"),
  overwrite = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{destination}{Location of the folder to save the reference files.}

\item{reference}{A string for either gg_ko, gg_cog, silva_ko, or
all. Defaults to all.}

\item{overwrite}{Logical flag to overwrite if file already exists. Default
to FALSE.}

\item{verbose}{Logical flag to print progress information. Defaults to FALSE.}
}
\description{
A function to download the KO and COG 13.5 GreenGenes reference tables for
PICRUSt prediction or the KO reference table for tax4fun prediction. The
data are stored at \url{https://gitlab.com/sw1/themetagenomics_data/}.
}
\examples{
\dontrun{
download_ref(destination='/references',reference='gg_ko')
}

}
\seealso{
\code{\link{picrust}} \code{\link{t4f}}
}
