% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_correlations.R
\name{plot_feature_correlations}
\alias{plot_feature_correlations}
\title{Produce a correlation matrix plot showing pairwise correlations of feature vectors by unique id with automatic hierarchical clustering.}
\usage{
plot_feature_correlations(
  data,
  is_normalised = NULL,
  id_var = "id",
  names_var = "names",
  values_var = "values",
  method = NULL,
  cor_method = c("pearson", "spearman"),
  clust_method = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  interactive = FALSE
)
}
\arguments{
\item{data}{a dataframe with at least 3 columns for \code{'id'}, \code{'names'} and \code{'values'}}

\item{is_normalised}{deprecated as of 0.4.0; do not use}

\item{id_var}{a string specifying the ID variable to compute pairwise correlations between. Defaults to \code{"id"}}

\item{names_var}{a string denoting the name of the variable/column that holds the feature names. Defaults to \code{"names"}}

\item{values_var}{a string denoting the name of the variable/column that holds the numerical feature values. Defaults to \code{"values"}}

\item{method}{deprecated as of 0.4.0; do not use}

\item{cor_method}{the correlation method to use. Defaults to \code{"pearson"}}

\item{clust_method}{the hierarchical clustering method to use for the pairwise correlation plot. Defaults to \code{"average"}}

\item{interactive}{a Boolean as to whether to plot an interactive \code{plotly} graphic. Defaults to \code{FALSE}}
}
\value{
an object of class \code{ggplot} that contains the correlation matrix graphic
}
\description{
Produce a correlation matrix plot showing pairwise correlations of feature vectors by unique id with automatic hierarchical clustering.
}
\examples{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)
  
plot_feature_correlations(data = featMat, 
  id_var = "id", 
  names_var = "names", 
  values_var = "values",
  cor_method = "pearson",
  clust_method = "average",
  interactive = FALSE)

}
\author{
Trent Henderson
}
