% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multi_feature_classifier.R
\name{fit_multi_feature_classifier}
\alias{fit_multi_feature_classifier}
\title{Fit a classifier to feature matrix using all features or all features by set}
\usage{
fit_multi_feature_classifier(
  data,
  id_var = "id",
  group_var = "group",
  by_set = FALSE,
  test_method = "gaussprRadial",
  use_balanced_accuracy = FALSE,
  use_k_fold = TRUE,
  num_folds = 10,
  use_empirical_null = FALSE,
  null_testing_method = c("ModelFreeShuffles", "NullModelFits"),
  p_value_method = c("empirical", "gaussian"),
  num_permutations = 100,
  seed = 123
)
}
\arguments{
\item{data}{the dataframe containing the raw feature data as calculated by \code{theft::calculate_features}}

\item{id_var}{a string specifying the ID variable to group data on (if one exists). Defaults to \code{"id"}}

\item{group_var}{a string specifying the grouping variable that the data aggregates to. Defaults to \code{"group"}}

\item{by_set}{Boolean specifying whether to compute classifiers for each feature set. Defaults to \code{FALSE}}

\item{test_method}{the algorithm to use for quantifying class separation. Defaults to \code{"gaussprRadial"}}

\item{use_balanced_accuracy}{a Boolean specifying whether to use balanced accuracy as the summary metric for caret model training. Defaults to \code{FALSE}}

\item{use_k_fold}{a Boolean specifying whether to use k-fold procedures for generating a distribution of classification accuracy estimates. Defaults to \code{TRUE}}

\item{num_folds}{an integer specifying the number of folds (train-test splits) to perform if \code{use_k_fold} is set to \code{TRUE}. Defaults to \code{10}}

\item{use_empirical_null}{a Boolean specifying whether to use empirical null procedures to compute p-values. Defaults to \code{FALSE}}

\item{null_testing_method}{a string specifying the type of statistical method to use to calculate p-values. Defaults to \code{model free shuffles}}

\item{p_value_method}{a string specifying the method of calculating p-values. Defaults to \code{"empirical"}}

\item{num_permutations}{an integer specifying the number of class label shuffles to perform if \code{use_empirical_null} is \code{TRUE}. Defaults to \code{100}}

\item{seed}{fixed number for R's random number generator to ensure reproducibility}
}
\value{
an object of class list containing dataframe summaries of the classification models and a \code{ggplot} object if \code{by_set} is \code{TRUE}
}
\description{
Fit a classifier to feature matrix using all features or all features by set
}
\examples{
\donttest{
featMat <- calculate_features(data = simData,
  id_var = "id",
  time_var = "timepoint",
  values_var = "values",
  group_var = "process",
  feature_set = "catch22",
  seed = 123)

fit_multi_feature_classifier(featMat,
  id_var = "id",
  group_var = "group",
  by_set = FALSE,
  test_method = "gaussprRadial",
  use_balanced_accuracy = FALSE,
  use_k_fold = TRUE,
  num_folds = 10,
  use_empirical_null = TRUE,
  null_testing_method = "ModelFreeShuffles",
  p_value_method = "gaussian",
  num_permutations = 50,
  seed = 123)
}

}
\author{
Trent Henderson
}
