% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.R
\name{flags}
\alias{flags}
\alias{flag_numeric}
\alias{flag_integer}
\alias{flag_boolean}
\alias{flag_string}
\title{Flags for a training run}
\usage{
flags(
  ...,
  config = Sys.getenv("R_CONFIG_ACTIVE", unset = "default"),
  file = "flags.yml",
  arguments = commandArgs(TRUE)
)

flag_numeric(name, default, description = NULL)

flag_integer(name, default, description = NULL)

flag_boolean(name, default, description = NULL)

flag_string(name, default, description = NULL)
}
\arguments{
\item{...}{One or more flag definitions}

\item{config}{The configuration to use. Defaults to the active configuration
for the current environment (as specified by the \code{R_CONFIG_ACTIVE}
environment variable), or \code{default} when unset.}

\item{file}{The flags YAML file to read}

\item{arguments}{The command line arguments (as a character vector) to be
parsed.}

\item{name}{Flag name}

\item{default}{Flag default value}

\item{description}{Flag description}
}
\value{
Named list of training flags
}
\description{
Define the flags (name, type, default value, description) which paramaterize
a training run. Optionally read overrides of the default values from a
"flags.yml" config file and/or command line arguments.
}
\section{Config File Flags}{


Config file flags are defined a YAML configuration file (by default
named "flags.yml"). Flags can either appear at the top-level of
the YAML or can be inclued in named configuration sections
(see the \href{https://github.com/rstudio/config}{config package} for
details).
}

\section{Command Line Flags}{


Command line flags should be of the form \code{--key=value} or
\verb{--key value}. The values are assumed to be valid \code{yaml} and
will be converted using \code{\link[=yaml.load]{yaml.load()}}.
}

\examples{
\dontrun{
library(tfruns)

# define flags and parse flag values from flags.yml and the command line
FLAGS <- flags(
  flag_numeric('learning_rate', 0.01, 'Initial learning rate.'),
  flag_integer('max_steps', 5000, 'Number of steps to run trainer.'),
  flag_string('data_dir', 'MNIST-data', 'Directory for training data'),
  flag_boolean('fake_data', FALSE, 'If true, use fake data for testing')
)
}

}
