% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/training_run.R
\name{tuning_run}
\alias{tuning_run}
\title{Tune hyperparameters using training flags}
\usage{
tuning_run(file = "train.R", context = "local",
  config = Sys.getenv("R_CONFIG_ACTIVE", unset = "default"), flags = NULL,
  sample = NULL, properties = NULL,
  runs_dir = getOption("tfruns.runs_dir", "runs"), echo = TRUE,
  confirm = interactive(), envir = parent.frame(),
  encoding = getOption("encoding"))
}
\arguments{
\item{file}{Path to training script (defaults to "train.R")}

\item{context}{Run context (defaults to "local")}

\item{config}{The configuration to use. Defaults to the active configuration
for the current environment (as specified by the \code{R_CONFIG_ACTIVE}
environment variable), or \code{default} when unset.}

\item{flags}{Named list with flag values (multiple values can be
provided for each flag)}

\item{sample}{Sampling rate for flag combinations (defaults to
running all combinations).}

\item{properties}{Named character vector with run properties. Properties are
additional metadata about the run which will be subsequently available via
\code{\link[=ls_runs]{ls_runs()}}.}

\item{runs_dir}{Directory containing runs. Defaults to "runs" beneath the
current working directory (or to the value of the \code{tfruns.runs_dir} R
option if specified).}

\item{echo}{Print expressions within training script}

\item{confirm}{Confirm before executing tuning run.}

\item{envir}{The environment in which the script should be evaluated}

\item{encoding}{The encoding of the training script; see \code{\link[=file]{file()}}.}
}
\value{
Data frame with summary of all training runs performed
during tuning.
}
\description{
Run all combinations of the specifed training flags. The number of
combinations can be reduced by specifying the \code{sample} parameter, which
will result in a random sample of the flag combinations being run.
}
\examples{
\dontrun{
library(tfruns)

runs <- tuning_run("mnist_mlp.R", flags = list(
  batch_size = c(64, 128),
  dropout1 = c(0.2, 0.3, 0.4),
  dropout2 = c(0.2, 0.3, 0.4)
))

runs[order(runs$eval_acc, decreasing = TRUE), ]

}

}
