% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_tfprobability}
\alias{install_tfprobability}
\title{Installs TensorFlow Probability}
\usage{
install_tfprobability(
  method = c("auto", "virtualenv", "conda"),
  conda = "auto",
  version = "default",
  tensorflow = "default",
  extra_packages = NULL,
  ...,
  pip_ignore_installed = TRUE
)
}
\arguments{
\item{method}{Installation method. By default, "auto" automatically finds a
method that will work in the local environment. Change the default to force
a specific installation method. Note that the "virtualenv" method is not
available on Windows.}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[reticulate:conda_binary]{conda_binary()}} for more details.}

\item{version}{TensorFlow version to install. Valid values include:
\itemize{
\item \code{"default"} installs  2.9
\item \code{"release"} installs the latest release version of tensorflow (which may
be incompatible with the current version of the R package)
\item A version specification like \code{"2.4"} or \code{"2.4.0"}. Note that if the patch
version is not supplied, the latest patch release is installed (e.g.,
\code{"2.4"} today installs version "2.4.2")
\item \code{nightly} for the latest available nightly build.
\item To any specification, you can append "-cpu" to install the cpu version
only of the package (e.g., \code{"2.4-cpu"})
\item The full URL or path to a installer binary or python *.whl file.
}}

\item{tensorflow}{Synonym for \code{version}. Maintained for backwards.}

\item{extra_packages}{Additional Python packages to install along with
TensorFlow.}

\item{...}{other arguments passed to \code{\link[reticulate:conda-tools]{reticulate::conda_install()}} or
\code{\link[reticulate:virtualenv-tools]{reticulate::virtualenv_install()}}, depending on the \code{method} used.}

\item{pip_ignore_installed}{Whether pip should ignore installed python
packages and reinstall all already installed python packages. This defaults
to \code{TRUE}, to ensure that TensorFlow dependencies like NumPy are compatible
with the prebuilt TensorFlow binaries.}
}
\value{
invisible
}
\description{
Installs TensorFlow Probability
}
