% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-layers.R
\name{layer_variational_gaussian_process}
\alias{layer_variational_gaussian_process}
\title{A Variational Gaussian Process Layer.}
\usage{
layer_variational_gaussian_process(
  object,
  num_inducing_points,
  kernel_provider,
  event_shape = 1,
  inducing_index_points_initializer = NULL,
  unconstrained_observation_noise_variance_initializer = NULL,
  mean_fn = NULL,
  jitter = 1e-06,
  name = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{num_inducing_points}{number of inducing points in the Variational Gaussian
Process distribution.}

\item{kernel_provider}{a \code{Layer} instance equipped with an \verb{@property}, which
yields a \code{PositiveSemidefiniteKernel} instance. The latter is used to parametrize
the constructed Variational Gaussian Process distribution returned by calling
the layer.}

\item{event_shape}{the shape of the output of the layer. This translates to a
batch of underlying Variational Gaussian Process distributions. For example,
\code{event_shape = 3} means we are modelling a batch of 3 distributions over functions.
We can think oof this as a distribution over 3-dimensional veector-valued
functions.}

\item{inducing_index_points_initializer}{a \code{tf.keras.initializer.Initializer}
used to initialize the trainable \verb{inducing_index_points variables}. Training
VGP's is pretty sensitive to choice of initial inducing index point locations.
A reasonable heuristic is to scatter them near the data, not too close to each
other.}

\item{unconstrained_observation_noise_variance_initializer}{a \code{tf.keras.initializer.Initializer}
used to initialize the unconstrained observation noise variable. The observation
noise variance is computed from this variable via the \code{tf.nn.softplus} function.}

\item{mean_fn}{a callable that maps layer inputs to mean function values.
Passed to the mean_fn parameter of Variational Gaussian Process distribution.
If omitted, defaults to a constant function with trainable variable value.}

\item{jitter}{a small term added to the diagonal of various kernel matrices for
numerical stability.}

\item{name}{name to give to this layer and the scope of ops and variables it
contains.}
}
\value{
a Keras layer
}
\description{
Create a Variational Gaussian Process distribution whose \code{index_points} are
the inputs to the layer. Parameterized by number of inducing points and a
\code{kernel_provider}, which should be a \code{tf.keras.Layer} with an @property that
late-binds variable parameters to a \code{tfp.positive_semidefinite_kernel.PositiveSemidefiniteKernel}
instance (this requirement has to do with the way that variables must be created
in a keras model). The mean_fn is an optional argument which, if omitted, will
be automatically configured to be a constant function with trainable variable
output.
}
