% Generated by roxygen2 (4.0.2): do not edit by hand
\name{make.count.table}
\alias{make.count.table}
\title{Count number of times documents have a given phrase.}
\usage{
make.count.table(phrases, labeling, corpus)
}
\arguments{
\item{phrases}{List of strings}

\item{labeling}{Vector of +1/0/-1 labels}

\item{corpus}{A corpus object from tm package}
}
\value{
a dataframe of statistics.  per.pos is the percent of the
documents with the phrase that are positively labeled.  per.tag is
the percent of the positively labeled documents that have the
phrase.
}
\description{
Given a list of phrases, count how many documents they appear in
and subdivide by positive and negative appearance.
}
\details{
This method does not consider multiple counts of phrases within documents.
Phrases can have wildcards and stemming notation.  See \code{\link{grab.fragments}}.
}
\examples{
library( tm )
data( bathtub )
lbl = meta( bathtub )$meth.chl
make.count.table( c("bathtub","strip+", "vapor *"), lbl, bathtub )
}
\seealso{
grab.fragments

Other textregCounting: \code{\link{make.phrase.matrix}};
  \code{\link{phrase.count}}
}

