% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textfeature.R
\name{step_textfeature}
\alias{step_textfeature}
\title{Calculate Set of Text Features}
\usage{
step_textfeature(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  extract_functions = textfeatures::count_functions,
  prefix = "textfeature",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("textfeature")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{extract_functions}{A named list of feature extracting functions.
default to \code{\link[textfeatures]{count_functions}} from the
textfeatures package. See details for more information.}

\item{prefix}{A prefix for generated column names, default to "textfeature".}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_textfeature()} creates a \emph{specification} of a recipe step that will
extract a number of numeric features of a text column.
}
\details{
This step will take a character column and returns a number of numeric
columns equal to the number of functions in the list passed to the
\code{extract_functions} argument. The default is a list of functions from the
textfeatures package.

All the functions passed to \code{extract_functions} must take a character vector
as input and return a numeric vector of the same length, otherwise an error
will be thrown.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) and \code{functions} (name of feature
functions).
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("textfeatures")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_textfeature(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL) \%>\%
  slice(1:2)

bake(tate_obj, new_data = NULL) \%>\%
  pull(textfeature_medium_n_words)

tidy(tate_rec, number = 1)
tidy(tate_obj, number = 1)

# Using custom extraction functions
nchar_round_10 <- function(x) round(nchar(x) / 10) * 10

recipe(~., data = tate_text) \%>\%
  step_textfeature(medium,
    extract_functions = list(nchar10 = nchar_round_10)
  ) \%>\%
  prep() \%>\%
  bake(new_data = NULL)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Steps for Numeric Variables From Characters: 
\code{\link{step_dummy_hash}()},
\code{\link{step_sequence_onehot}()}
}
\concept{Steps for Numeric Variables From Characters}
