% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textfeature.R
\name{step_textfeature}
\alias{step_textfeature}
\alias{tidy.step_textfeature}
\title{Generate the basic set of text features}
\usage{
step_textfeature(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  extract_functions = textfeatures::count_functions,
  prefix = "textfeature",
  skip = FALSE,
  id = rand_id("textfeature")
)

\method{tidy}{step_textfeature}(x, ...)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{extract_functions}{A named list of feature extracting functions.
default to \code{\link[textfeatures]{count_functions}} from the textfeatures
package. See details for more information.}

\item{prefix}{A prefix for generated column names, default to "textfeature".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_textfeature} object.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_textfeature} creates a \emph{specification} of a recipe step that
will extract a number of numeric features of a text column.
}
\details{
This step will take a character column and returns a number of numeric
columns equal to the number of functions in the list passed to the
\code{extract_functions} argument. The default is a list of functions from the
textfeatures package.

All the functions passed to \code{extract_functions} must take a character vector
as input and return a numeric vector of the same length, otherwise an error
will be thrown.
}
\examples{
if (requireNamespace("textfeatures", quietly = TRUE)) {
  library(recipes)
  library(modeldata)
  data(okc_text)

  okc_rec <- recipe(~., data = okc_text) \%>\%
    step_textfeature(essay0)

  okc_obj <- okc_rec \%>\%
    prep()

  bake(okc_obj, new_data = NULL) \%>\%
    slice(1:2)

  bake(okc_obj, new_data = NULL) \%>\%
    pull(textfeature_essay0_n_words)

  tidy(okc_rec, number = 1)
  tidy(okc_obj, number = 1)

  # Using custom extraction functions
  nchar_round_10 <- function(x) round(nchar(x) / 10) * 10

  recipe(~., data = okc_text) \%>\%
    step_textfeature(essay0,
      extract_functions = list(nchar10 = nchar_round_10)
    ) \%>\%
    prep() \%>\%
    bake(new_data = NULL)
}

}
\seealso{
Other character to numeric steps: 
\code{\link{step_lda}()},
\code{\link{step_sequence_onehot}()}
}
\concept{character to numeric steps}
