% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{read_pptx}
\alias{read_pptx}
\title{Read in .pptx Content}
\usage{
read_pptx(
  file,
  skip = 0,
  remove.empty = TRUE,
  trim = TRUE,
  include.notes = FALSE,
  ...
)
}
\arguments{
\item{file}{The path to the .pptx file.}

\item{skip}{The number of lines to skip.}

\item{remove.empty}{logical.  If \code{TRUE} empty elements in the vector are
removed.}

\item{trim}{logical.  If \code{TRUE} the leading/training white space is
removed.}

\item{include.notes}{logical.  If \code{TRUE} then slide notes are included.}

\item{...}{ignored.}
}
\value{
Returns a \code{\link[base:data.frame]{base::data.frame()}} with the slide number
(\code{slide_id}), line number (\code{element_id}), and the \code{text}.
}
\description{
Read in the content from a .pptx file.
}
\examples{
\dontrun{
url <- file.path("https://www.oclc.org/content/dam/research/presentations", 
    "2019/111319-godby-NISO-What-Are-Entities-Matter.pptx")
file <- download(url)
(txt <- read_pptx(file))

pptx_doc <- system.file('docs/Hello_World.pptx', package = "textreadr")
read_pptx(pptx_doc)
read_pptx(pptx_doc, include.notes = TRUE)
}
}
\keyword{pptx}
