% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set_functions.R
\name{setDoc}
\alias{setDoc}
\title{Function to change documents for textmining objects}
\usage{
setDoc(x, doc, i = 1)
}
\arguments{
\item{x}{text mining object tmCorpus or tmTextDocument}

\item{doc}{element to be attached as content}

\item{i}{index}
}
\value{
x with changed i-th document
}
\description{
Function to change documents for textmining objects
}
\examples{
corp <- tmCorpus(c("This is first document", "This is second"))
corp <- setDoc(corp, "Changed doc", 1)
getDoc(corp, 1)
content(corp) <- c("Content 1", "Content 2")
content(corp)

text <- tmTextDocument("Text document new")
text <- setDoc(text, "Content no 1")
getDoc(text)
content(text)

parsed <- tmParsed(list(c("Parsed", "doc", "one"), c("Parsed", "two")))
parsed <- setDoc(parsed, c("Changed", "document"), 2)
getDoc(parsed, 2)
content(parsed) <- list(c("Changed", "document", "one"), c("Changed", "two"))
content(parsed)

}

