% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_set_functions.R
\name{getMeta}
\alias{getMeta}
\title{Function to access meta data for textmining objects}
\usage{
getMeta(x, parameter, i = 1)
}
\arguments{
\item{x}{textmining object tmCorpus or tmTextDocument}

\item{parameter}{name of metadata to be extracted}

\item{i}{index}
}
\value{
returns i-th document of corpus x
}
\description{
Function to access meta data for textmining objects
}
\examples{
corp <- tmCorpus(c("This is first document", "This is second"))
getMeta(corp, parameter = "language", 1)
getMeta(corp, "title", 2)
meta(corp, "title")

text <- tmTextDocument("Text document")
getMeta(text, "language")
meta(text, "title")

parsed <- tmParsed(list(c("Parsed", "doc", "one"), c("Parsed", "two")))
getMeta(parsed, parameter = "title",  2)
meta(parsed, "title")

}

