% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_non_ascii.R
\name{replace_non_ascii}
\alias{replace_non_ascii}
\alias{replace_curly_quote}
\title{Replace Common Non-ASCII Characters}
\usage{
replace_non_ascii(x, remove.nonconverted = TRUE, ...)

replace_curly_quote(x, ...)
}
\arguments{
\item{x}{The text variable.}

\item{remove.nonconverted}{logical.  If \code{TRUE} unmapped encodings are
deleted from the string.}

\item{\dots}{ignored.}
}
\value{
Returns a text variable (character sting) with non-ASCII characters 
replaced.
}
\description{
\code{replace_non_ascii} - Replaces common non-ASCII characters.

\code{replace_curly_quote} - Replaces curly single and doble quotes.  This 
provides a subset of functionality found in \code{replace_non_ascii} specific 
to quotes.
}
\examples{
x <- c(
    "Hello World", "6 Ekstr\\xf8m", "J\\xf6reskog", "bi\\xdfchen Z\\xfcrcher",
    'This is a \\xA9 but not a \\xAE', '6 \\xF7 2 = 3', 'fractions \\xBC, \\xBD, \\xBE',
    'cows go \\xB5', '30\\xA2'
)
Encoding(x) <- "latin1"
x

replace_non_ascii(x)
replace_non_ascii(x, remove.nonconverted = FALSE)

z <- '\\x95He said, \\x93Gross, I am going to!\\x94'
Encoding(z) <- "latin1"
z

replace_curly_quote(z)
replace_non_ascii(z)
}
\keyword{ascii}
