% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenizers.R
\name{tokenizers}
\alias{tokenizers}
\alias{word_tokenizer}
\alias{regexp_tokenizer}
\alias{char_tokenizer}
\alias{space_tokenizer}
\title{Simple tokenization functions for string splitting}
\usage{
word_tokenizer(strings, ...)

regexp_tokenizer(strings, pattern, ...)

char_tokenizer(strings, ...)

space_tokenizer(strings, sep = " ", xptr = FALSE, ...)
}
\arguments{
\item{strings}{\code{character} vector}

\item{...}{other parameters to \link{strsplit} function, which is used under the hood.}

\item{pattern}{\code{character} pattern symbol.}

\item{sep}{\code{character}, \code{nchar(sep)} = 1 - split strings by this character.}

\item{xptr}{\code{logical} tokenize at C++ level - could speed-up by 15-50\%.}
}
\value{
\code{list} of \code{character} vectors. Each element of list contains vector of tokens.
}
\description{
very thin wrappers around \code{base} regular expressions.
\bold{For much more faster and functional tokenizers see \code{tokenizers} package:
\url{https://cran.r-project.org/package=tokenizers}}.
The reason for not including this to \code{text2vec} is to keep number of dependencies small.
Also check \code{stringi::stri_split_*} and \code{stringr::str_split_*}.
}
\examples{
doc = c("first  second", "bla, bla, blaa")
# split by words
word_tokenizer(doc)
#faster, but far less general - perform split by a fixed single whitespace symbol.
space_tokenizer(doc, " ")
}
